/*****************************************************************************
*
* Copyright 2019 NXP
* All Rights Reserved
*
*****************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
****************************************************************************/

#ifndef APUADDPROCESS_H
#define APUADDPROCESS_H

#include "common_base_process_init.h"
#include "add_graph_names.h"


#include <umat.hpp>

#ifdef APEX2_EMULATE
#include "add_apu_process_desc.hpp"
REGISTER_PROCESS_TYPE(ADD_PI, AddApuProcessDesc)
#else


#include str_header(ADD_PI,hpp)
#endif


class CTemplate_Demo_Proc : public CBase_ProcInit<ADD_PI> {
private:
public:	
	// Input data created eventually by other processes or read in
	vsdk::UMat lInputA;
	vsdk::UMat lInputB;

	// Outputs generated by this process
	vsdk::UMat lOutput;
public:
	CTemplate_Demo_Proc(int32_t apex_id = 0)
	: CBase_ProcInit<ADD_PI>(apex_id)
	{}

	virtual ~CTemplate_Demo_Proc();
	int InitData(vsdk::UMat inputA, vsdk::UMat inputB);

	int32_t Connect();

};

#endif /* APUADDPROCESS_H */


